﻿using iText.Html2pdf.Attach;
using iText.Html2pdf.Attach.Impl.Tags;
using iText.Html2pdf.Html.Node;
using iText.Kernel.Pdf.Tagging;
using iText.Kernel.Pdf.Tagutils;
using iText.Layout;
using iText.Layout.Tagging;

namespace NVCC.WebUI.Infrastructure.iTextCustom
{
    public class ThWithScopeTagWorker : ThTagWorker
    {
        public ThWithScopeTagWorker(IElementNode element, ProcessorContext context) : base(element, context)
        {
        }

        public override void ProcessEnd(IElementNode element, ProcessorContext context)
        {
            base.ProcessEnd(element, context);
            IPropertyContainer elementResult = base.GetElementResult();
            if (elementResult is IAccessibleElement)
            {
                ((IAccessibleElement)elementResult).GetAccessibilityProperties().SetRole(StandardRoles.TH);

                //Can use this in the future in case we have th elements with different scope than "col"
                //string htmlScope = element.GetAttribute("scope"); //This is the scope="XXX" in your HTML

                AccessibilityProperties properties = ((IAccessibleElement)elementResult).GetAccessibilityProperties();
                properties.AddAttributes(new PdfStructureAttributes("Table").AddEnumAttribute("Scope", "Column"));
            }
        }

    }
}